IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'CPJ_Contrato_Facturar_V2') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE CPJ_Contrato_Facturar_V2
END
GO

CREATE  PROCEDURE dbo.CPJ_Contrato_Facturar_V2 @pJsonRecibido VARCHAR(8000)
AS 
SET NOCOUNT ON

DECLARE 	@pLote				VARCHAR(50),
			@pFecha				DATETIME,
			@pDescripcion		VARCHAR(50),
			@pId_Lote_Tipo		SMALLINT,
			@pFecha_Desde		DATETIME,
			@pFecha_Hasta		DATETIME,
			@pFecha_Rem_Desde	DATETIME,
			@pFecha_Rem_Hasta	DATETIME,
			@pFecha_QA       	DATETIME,
			@pFecha_Venc     	DATETIME,
			@pId_Tipo_Cont      INT,
			@pId_Usuario		INT,
			@pFiltrarTarjeta    Tinyint,
			@pFiltrarCliente    Tinyint,
			@pFiltrarCondPago   Tinyint,
			@pFiltrarTipoCbte   Tinyint,
			@pFiltrarCantCont   INT,
			@pRefacturar        TINYINT,
			@pIncl_Cbtes_Cero   Tinyint,
			@pFlagUsarTrans		TINYINT,
			@pModoDebug			TINYINT

SET @pLote				= ISNULL(CONVERT(VARCHAR(50), dbo.CF_JSON_VALUE(@pJsonRecibido,'Lote')), '')
SET @pFecha				= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJsonRecibido,'Fecha')),GETDATE())
SET @pDescripcion		= ISNULL(CONVERT(VARCHAR(50), dbo.CF_JSON_VALUE(@pJsonRecibido,'Descripcion')), '')
SET @pId_Lote_Tipo		= ISNULL(CONVERT(SMALLINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Id_Lote_Tipo')), 0)
SET @pFecha_Desde		= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJsonRecibido,'Fecha_Desde')),GETDATE())
SET @pFecha_Hasta		= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJsonRecibido,'Fecha_Hasta')),GETDATE())
SET @pFecha_Rem_Desde	= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJsonRecibido,'Fecha_Rem_Desde')),GETDATE())
SET @pFecha_Rem_Hasta	= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJsonRecibido,'Fecha_Rem_Hasta')),GETDATE())
SET @pFecha_QA			= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJsonRecibido,'Fecha_QA')),@pFecha_Desde)
SET @pFecha_Venc		= CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJsonRecibido,'Fecha_Venc'))
SET @pId_Tipo_Cont		= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Id_Tipo_Cont')), 0)
SET @pId_Usuario		= ISNULL(CONVERT(SMALLINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Id_Usuario')), 0)
SET @pFiltrarTarjeta	= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'FiltrarTarjeta')), 0)
SET @pFiltrarCliente	= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'FiltrarCliente')), 0)
SET @pFiltrarCondPago	= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'FiltrarCondPago')), 0)
SET @pFiltrarTipoCbte	= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'FiltrarTipoCbte')), 0)
SET @pFiltrarCantCont	= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJsonRecibido,'FiltrarCantCont')), 0)
SET @pRefacturar		= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Refacturar')), 0)
SET @pIncl_Cbtes_Cero   = ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Incl_Cbtes_Cero')), 0)
SET @pFlagUsarTrans		= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'FlagUsarTrans')), 0)
SET @pModoDebug			= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'ModoDebug')), 0)

/*Declaracion Variables Locales*/
DECLARE @Mensaje			VARCHAR(100)
		,@UltError			INT
		,@Segundos			INT

DECLARE @Result_Tabla_Stored_Invocado TABLE (ErrorNumber		INT,
											 ErrorSeverity		INT,
											 ErrorState			INT,
											 ErrorProcedure		VARCHAR(1000),
											 ErrorLine			INT,
											 ErrorMessage		VARCHAR(4000))


CREATE TABLE #Total_Contratos  (Id_Contrato		INT,
								Id_Tiempo		CHAR(3),
								Id_Cliente		INT,
								Id_Tipo_Con		SMALLINT,
								Id_Cliente_Ref	INT,
								Id_Lista_Precio INT,
								Imp_Bonif		DECIMAL(12,2),
								Porc_Bonif		DECIMAL(5,2))

	CREATE NONCLUSTERED INDEX IX_Total_Contratos_xId_Cliente
		ON #Total_Contratos (Id_Contrato,Id_Cliente)
	
	CREATE NONCLUSTERED INDEX IX_Total_Contratos_xId_Tipo_Con
		ON #Total_Contratos (Id_Contrato,Id_Tipo_Con)
	
	CREATE NONCLUSTERED INDEX IX_Total_Contratos_xId_Cliente_Ref
		ON #Total_Contratos (Id_Cliente,Id_Cliente_Ref)


CREATE TABLE #Total_Contratos_Items  (Id_Producto			VARCHAR(14),
									  Id_Tiempo				CHAR(4),
									  Id_Cliente			INT,
									  Id_Contrato			INT,
									  Precio_Item			DECIMAL(20,5),
									  Cantidad				DECIMAL(12,2),
									  Id_Trans_Remito		INT,
									  Id_Cliente_Ref		INT,
									  Id_Lista_Precio		INT,
									  Ult_Fecha_Fact		DATETIME NULL,
									  Flag_Mes_Desglo		SMALLINT,
									  Id_Cond_Pago_Prod		INT)

	CREATE NONCLUSTERED INDEX IX_Total_Contratos_Items_xId_Producto
		ON #Total_Contratos_Items (Id_Producto,Id_Contrato)

	CREATE NONCLUSTERED INDEX IX_Total_Contratos_Items_xId_Cliente
		ON #Total_Contratos_Items (Id_Contrato,Id_Cliente)

CREATE TABLE #Ult_Fech_Fac (Id_Contrato		INT,
							Ult_Fecha_Fact	DATETIME)

	CREATE NONCLUSTERED INDEX IX_Ult_Fech_Fac_xUlt_Fecha_Fact
		ON #Ult_Fech_Fac (Id_Contrato,Ult_Fecha_Fact)

DECLARE @Sql								VARCHAR(MAX)
DECLARE @SqlSaldo							VARCHAR(MAX)
DECLARE @SqlSelect							VARCHAR(MAX)
DECLARE @SqlFrom							VARCHAR(MAX)
DECLARE @SqlWhere							VARCHAR(MAX)
DECLARE @SqlGroup							VARCHAR(MAX)
DECLARE @Id_Contrato						INT
DECLARE @Id_Trans							INT
DECLARE @Id_Tiempo							CHAR(3)
DECLARE @Flag_Agru_Cli_Ref					TINYINT
DECLARE @Lote_en_proceso					SMALLINT
DECLARE @Procesa_Remitos					INT
DECLARE @pJson								VARCHAR(8000)
DECLARE @Id_Lista_Precio_Cont				INT
DECLARE @Id_Lista_Precio_Cli_Esp			INT
DECLARE @Id_Lista_Precio_Cli				INT
DECLARE @Id_Lista_Precio					INT
DECLARE @Prox_Trans							INT
DECLARE @AlterTable							VARCHAR(1500)
DECLARE @Cond_Pago_Lote						INT
DECLARE @Iva_1								DECIMAL(12,2)
DECLARE @Iva_2								DECIMAL(12,2)
DECLARE @Iva_3								DECIMAL(12,2)
DECLARE @pCant_Dig_Cbtes					INT
DECLARE @pCant_Dig_Rem						INT
DECLARE @JSON_Parametros_Stored_Invocado	VARCHAR(8000)
DECLARE @Result_Stored_Invocado				INT
DECLARE @Id_Producto_Bonif					VARCHAR(25)
DECLARE @Generar_Tabla_Desc					INT
DECLARE @Id_Producto_Bonif_Cond_Pago		INT



BEGIN TRY
	------------------------------------------------------------ VALIDACIONES Y SETEOS GENERALES ------------------------------------------------------------

	SET @Lote_en_proceso = ISNULL((SELECT COUNT(*) FROM Cbtes_Lotes WHERE Flag_enProceso = 1),0)
	IF @Lote_en_proceso <> 0
		RAISERROR ('Existe actualmente otro Lote en proceso', 16, 1) 
	
	UPDATE Clientes SET Id_Cliente_Ref = 0 WHERE Id_Cliente_Ref IS NULL AND Activo = 1

	SELECT	
		@Flag_Agru_Cli_Ref	 = ISNULL(Flag_Agru_Cli_Ref, 0),
		@Procesa_Remitos	 = ISNULL(Flag_Remitos, 0)
		FROM Contratos_Tipos
		WHERE Id_Tipo_Con	 = @pId_Tipo_Cont

	SET @Cond_Pago_Lote			= ISNULL(CONVERT(INT,dbo.CF_xParam('Cond_pago_Lotes_Cont')),0)
	SET @Iva_1					= dbo.CF_xParam('Tasa_Iva_1')
	SET @Iva_2					= dbo.CF_xParam('Tasa_Iva_2')
	SET @Iva_3					= dbo.CF_xParam('Tasa_Iva_3')
	SET @pCant_Dig_Cbtes		= dbo.CF_xParam('Cant_Dig_Cbtes')
	SET @pCant_Dig_Rem			= dbo.CF_xParam('Cant_Dig_Rem')
	SET @Id_Producto_Bonif		= dbo.CF_xParam('Lote_Bonif_Prod')

	IF(@Id_Producto_Bonif = '0')
	BEGIN
		SET @Id_Producto_Bonif = ''
	END

	IF @Cond_Pago_Lote <> 0 
	BEGIN
	   DECLARE @cant_dias INT
	   SET @cant_dias = (SELECT Plazo_Venc FROM Cbtes_Cond_Pago WHERE Id_Cond_Pago = @Cond_Pago_Lote)
	   SET @pFecha_Venc = DATEADD(day,@cant_dias,@pFecha)
	END

	
	SET @pFecha_Venc		= ISNULL(@pFecha_Venc,@pFecha_Hasta)

	------------------------------------------------------------ FIN VALIDACIONES Y SETEOS GENERALES ------------------------------------------------------------

	------------------------------------------------------------- GENERO TABLAS DE DATOS A INSERTAR ------------------------------------------------------------

	-- Creo tabla con el total de los contratos a Total_Contratos_Cbtes
	SET @SqlSelect = 'SELECT O.ID_CONTRATO,ISNULL(O.ID_TIEMPO,''''), O.Id_Cliente, O.Id_Tipo_Con, C.Id_Cliente_Ref, CASE	
																														WHEN ISNULL(O.Id_Lista_Precio,0) <> 0 THEN O.Id_Lista_Precio
																														WHEN ISNULL(C.Id_Precio_Especial,0) <> 0 THEN C.Id_Precio_Especial
																														WHEN ISNULL(C.Id_Lista_Precio,0) <> 0 THEN C.Id_Lista_Precio
																													END AS Id_Lista_Precio,
																													O.Imp_Bonif, O.Porc_Bonif'

	IF @pFiltrarCantCont > 0 
		SET @SqlSelect = 'SELECT TOP ' + CAST(@pFiltrarCantCont AS VARCHAR(10)) + '  O.ID_CONTRATO,ISNULL(O.ID_TIEMPO,''''), O.Id_Cliente, O.Id_Tipo_Con, C.Id_Cliente_Ref, CASE	
																																												WHEN ISNULL(O.Id_Lista_Precio,0) <> 0 THEN O.Id_Lista_Precio
																																												WHEN ISNULL(C.Id_Precio_Especial,0) <> 0 THEN C.Id_Precio_Especial
																																												WHEN ISNULL(C.Id_Lista_Precio,0) <> 0 THEN C.Id_Lista_Precio
																																											END AS Id_Lista_Precio,
																																											O.Imp_Bonif, O.Porc_Bonif'

	SET @SqlFrom = 'FROM Contratos O, Clientes C'

	SET @SqlWhere = '  WHERE O.Id_Tipo_Con = ' + CAST(@pId_Tipo_Cont AS VARCHAR(10)) + '
							AND O.Id_Cliente = C.Id_Cliente 
							AND C.Activo = 1  AND O.Activo = 1
							AND ( O.Fecha_Hasta >= '''+ CONVERT(VARCHAR(8),@pFecha_Desde+1,112) +'''
								OR O.Fecha_Hasta IS NULL)
 							AND O.Fecha_Desde < '''+ CONVERT(VARCHAR(8),@pFecha_Hasta+1,112) +'''
							AND (O.Fecha_Cob_Hasta < '''+ CONVERT(VARCHAR(8),@pFecha_Hasta+1,112) +'''
								OR O.Fecha_Cob_Hasta IS NULL)
							AND (EXISTS (SELECT P.Id_Contrato FROM Contratos_Prod P WHERE P.Id_Contrato = O.Id_Contrato 
											AND ISNULL(P.Flag_Facturable,0) <> 0 )
								OR (EXISTS (SELECT 1 FROM Contratos_Tipos_Prod CT WHERE CT.Id_Tipo_Con = O.Id_Tipo_Con ))) '

	IF	@Flag_Agru_Cli_Ref <> 0 
		SET @SqlWhere = RTRIM(LTRIM(@SqlWhere)) + ' AND C.Id_Cliente_Ref = 0' --5/9

	IF	@pFiltrarCondPago <> 0 
		SET @SqlWhere = RTRIM(LTRIM(@SqlWhere)) + ' AND C.Id_Cond_Pago IN (SELECT CP.PTR FROM TagFile_ CP WHERE CP.USR = ' + CAST(@pId_Usuario AS VARCHAR(10)) + ' AND CP.TBL = 150)'
 
	IF	@pFiltrarTipoCbte <> 0 
		SET @SqlWhere = RTRIM(LTRIM(@SqlWhere)) + ' AND O.Id_tipo_cbte IN (SELECT CT.POS FROM TagFilePos_ CT WHERE CT.USR = ' + CAST(@pId_Usuario AS VARCHAR(10)) + ' AND CT.TBL = 120)'

	IF	@pFiltrarCliente <> 0 
		SET @SqlWhere = RTRIM(LTRIM(@SqlWhere)) + ' AND C.ID_CLIENTE IN (SELECT CP.PTR FROM TagFile_ CP WHERE CP.USR = ' + CAST(@pId_Usuario AS VARCHAR(10)) + ' AND CP.TBL = 400)'

	IF	@pFiltrarTarjeta <> 0 
		SET @SqlWhere = RTRIM(LTRIM(@SqlWhere)) + ' AND ( ISNULL(O.Id_Tarjeta,'') IN (SELECT TAR.POS FROM TagFilePos_ TAR WHERE TAR.USR = ' + CAST(@pId_Usuario AS VARCHAR(10)) + ' AND TAR.TBL = 210)
													OR ISNULL(C.Id_Tarjeta,'') IN (SELECT TAR.POS FROM TagFilePos_ TAR WHERE TAR.USR = ' + CAST(@pId_Usuario AS VARCHAR(10)) + ' AND TAR.TBL = 210) )'

	IF @pRefacturar  <> 1 													
		SET @SqlWhere = RTRIM(LTRIM(@SqlWhere)) + ' AND O.ID_Contrato NOT IN (SELECT ID_Contrato  FROM #Z_Contratos_Facturados P WHERE P.ID_Contrato = O.ID_Contrato)'

	SET @SqlGroup = 'ORDER BY O.ID_CLIENTE'

	SET @Sql = @SqlSelect +' '+ @SqlFrom + ' ' + @SqlWhere + ' ' + @SqlGroup

	IF @pModoDebug <> 0	
	BEGIN
		PRINT @Sql
	END

	-- Inserto el nuevo lote
	INSERT INTO Cbtes_Lotes (Lote,Fecha,Descripcion,Id_Lote_Tipo,Flag_enProceso,Fecha_Inicio,Fecha_Desde,Fecha_Hasta,Observacion,Id_Tipo_Con)
		VALUES (@pLote,@pFecha,@pDescripcion,@pId_Lote_Tipo,1,GETDATE(),@pFecha_Desde,@pFecha_Hasta,@Sql,@pId_Tipo_Cont)

    IF @pModoDebug <> 0	
	BEGIN
		PRINT 'Agregue en Cbtes_Lotes. Hora Ejecucion: ' + CONVERT(VARCHAR(25),GETDATE())
	END

	-- Creo tabla con contratos ya facturados
	IF OBJECT_ID (N'#Z_Contratos_Facturados', N'U') IS NOT NULL 
	BEGIN
		DROP TABLE #Z_Contratos_Facturados
	END

	IF(@pRefacturar <> 1)
	BEGIN
		SELECT ISNULL(I.Id_Cliente,C.ID_CLIENTE) As Id_Cliente, i.Id_Producto, Isnull(c.Id_Contrato,0) As Id_Contrato, count(*) As Cantidad
 				Into #Z_Contratos_Facturados
				FROM Cbtes_Items i, Cbtes c , Cbtes_Tipos T, Contratos O
						WHERE c.id_trans = i.id_trans 
									AND T.Id_Tipo_Cbte = C.Id_Tipo_Cbte
									AND C.Id_Contrato = O.Id_Contrato
									AND ((c.Comprobante_Nro = 0 AND c.Id_Estado_Cbte = 3) 
									or  (c.Id_Estado_Cbte <> 0 and c.Id_Estado_Cbte <> 3))
									AND (T.Compromete_Factura = 1
 									OR T.Compromete_Remitos = 1)
									AND DATEPART(yy,i.Fecha_QA) = DATEPART(yy,@pFecha_QA) 
									AND DATEPART(mm,i.Fecha_QA) = DATEPART(mm,@pFecha_QA) 
									AND O.Id_Tipo_Con = @pId_Tipo_Cont
									group by ISNULL(I.Id_Cliente,C.ID_CLIENTE) , i.Id_Producto	, c.Id_Contrato


		CREATE NONCLUSTERED INDEX IX_CONT_FACT_Cli
				ON dbo.#Z_Contratos_Facturados (Id_Cliente,Id_producto)
                 
		CREATE NONCLUSTERED INDEX IX_CONT_FACT_Cont
				ON dbo.#Z_Contratos_Facturados (Id_Contrato) 
        IF @pModoDebug <> 0	
		BEGIN	
			PRINT 'Agregue en  #Z_Contratos_Facturados. Hora Ejecucion: ' + CONVERT(VARCHAR(25),GETDATE())
		END
	END

	-- Creo tabla con todos los productos facturados para este periodo
	IF OBJECT_ID (N'#Z_Productos_Facturados', N'U') IS NOT NULL 
	BEGIN
		DROP TABLE #Z_Productos_Facturados
	END

	IF(@pRefacturar <> 1)
	BEGIN
		SELECT L.Id_Cliente, I.Id_Producto
				INTO #Z_Productos_Facturados
				FROM Cbtes_Items I
					JOIN Clientes L ON L.Id_Cliente = I.Id_Cliente
					JOIN Cbtes C ON I.Id_Trans = C.Id_Trans 
					JOIN Cbtes_Tipos CT ON C.Id_Tipo_Cbte = CT.Id_Tipo_Cbte
				WHERE C.Id_Estado_Cbte NOT IN (0,3)
					AND CT.Compromete_Factura = 1
					AND DATEPART(yy,I.Fecha_QA) = DATEPART(yy,@pFecha_QA) 
					AND DATEPART(mm,I.Fecha_QA) = DATEPART(mm,@pFecha_QA) 
				GROUP BY L.Id_Cliente, I.Id_Producto

		CREATE NONCLUSTERED INDEX IX_FACT_Prod_Cli
				ON #Z_Productos_Facturados (Id_Cliente,Id_producto)
	
		IF @pModoDebug <> 0	
		BEGIN
			PRINT 'Agregue en  #Z_Productos_Facturados. Hora Ejecucion: ' + CONVERT(VARCHAR(25),GETDATE())
		END
	END 

	INSERT INTO #Total_Contratos
		EXEC(@sql)

    IF @pModoDebug <> 0	
	BEGIN
		PRINT 'Agregue en  #Total_Contratos. Hora Ejecucion: ' + CONVERT(VARCHAR(25),GETDATE())
	END

	IF(@pRefacturar = 1)
	BEGIN
		-- Creo tabla con Ult Fecha de Facturacion de contratos para filtro de uni de tiempo sin lo ya facturado para el mes corriente
		INSERT INTO #Ult_Fech_Fac 
		SELECT C.Id_Contrato, MAX(C.Fecha) AS Ult_Fecha_Fact
			FROM Cbtes C
					JOIN Contratos O ON C.Id_Contrato = O.Id_Contrato
					LEFT JOIN Cbtes_Items I ON I.Id_Trans = C.Id_Trans 
					LEFT JOIN Cbtes_Tipos T ON C.Id_Tipo_Cbte = T.Id_Tipo_Cbte
			WHERE C.Id_Estado_Cbte NOT IN (0,3)
					AND T.Compromete_Factura = 1
					AND O.Activo = 1          
					AND (O.Fecha_Hasta >= DATEADD(DAY,1,@pFecha_Desde) OR O.Fecha_Hasta IS NULL)
 					AND O.Fecha_Desde < DATEADD(DAY,1,@pFecha_Hasta)
					AND (O.Fecha_Cob_Hasta < DATEADD(DAY,1,@pFecha_Hasta))
					AND I.Fecha_QA <> @pFecha_QA
			GROUP BY C.Id_Contrato
	END
	ELSE
	BEGIN
		-- Creo tabla con Ult Fecha de Facturacion de contratos para filtro de uni de tiempo
		INSERT INTO #Ult_Fech_Fac 
		SELECT C.Id_Contrato, MAX(C.Fecha) AS Ult_Fecha_Fact
			FROM Cbtes C
					JOIN Contratos O ON C.Id_Contrato = O.Id_Contrato
					LEFT JOIN Cbtes_Items I ON I.Id_Trans = C.Id_Trans 
					LEFT JOIN Cbtes_Tipos T ON C.Id_Tipo_Cbte = T.Id_Tipo_Cbte
			WHERE C.Id_Estado_Cbte NOT IN (0,3)
					AND T.Compromete_Factura = 1
					AND O.Activo = 1          
					AND (O.Fecha_Hasta >= DATEADD(DAY,1,@pFecha_Desde) OR O.Fecha_Hasta IS NULL)
 					AND O.Fecha_Desde < DATEADD(DAY,1,@pFecha_Hasta)
					AND (O.Fecha_Cob_Hasta < DATEADD(DAY,1,@pFecha_Hasta))
			GROUP BY C.Id_Contrato
	END
	
	IF @pModoDebug <> 0	
	BEGIN
		PRINT 'Agregue en  #Ult_Fech_Fac. Hora Ejecucion: ' + CONVERT(VARCHAR(25),GETDATE())
	END
	
	IF(@Id_Producto_Bonif <> '')
	BEGIN
		-- Creo tabla #Total_Contratos_Cbtes con filtros por uni de tiempo y productos
		IF(@pRefacturar <> 1)
		BEGIN
			INSERT INTO #Total_Contratos_Items
			SELECT P.Id_Producto, Z.ID_TIEMPO, Z.Id_Cliente, 
					Z.Id_Contrato,(dbo.CF_Produc_Precio(P.Id_Producto, Z.Id_Cliente, @pFecha_QA, Z.Id_Contrato, 0,  'B')) AS Precio_Item, C.Cantidad,
					0 AS Id_Trans_Remito, Z.Id_Cliente_Ref, Z.Id_Lista_Precio, UF.Ult_Fecha_Fact, P.Flag_Mes_Desglo, ISNULL(P.Id_Cond_Pago,@Cond_Pago_Lote)	
					FROM Contratos_Tipos_Prod C
						LEFT JOIN Productos P ON C.Id_Producto  = P.Id_Producto 
						JOIN #Total_Contratos Z ON C.Id_Tipo_Con = Z.Id_Tipo_Con
						LEFT JOIN #Z_Productos_Facturados Z1 ON P.Id_Producto  = Z1.Id_Producto  AND Z.ID_CLIENTE = Z1.Id_Cliente
						JOIN #Ult_Fech_Fac UF ON UF.Id_Contrato = Z.Id_Contrato
					WHERE C.Id_Producto <> '' AND Z1.Id_Cliente IS NULL

			IF(@Flag_Agru_Cli_Ref = 1)
			BEGIN
				INSERT INTO #Total_Contratos_Items
				SELECT P.Id_Producto, Z.ID_TIEMPO, L.Id_Cliente, 
						Z.Id_Contrato,(dbo.CF_Produc_Precio(P.Id_Producto, O.Id_Cliente, @pFecha_QA, O.Id_Contrato, 0,  'B')) AS Precio_Item, C.Cantidad,
						0 AS Id_Trans_Remito, Z.Id_Cliente_Ref, Z.Id_Lista_Precio, UF.Ult_Fecha_Fact, P.Flag_Mes_Desglo, ISNULL(P.Id_Cond_Pago,@Cond_Pago_Lote)	
						FROM Contratos O
							LEFT JOIN Clientes L ON L.Id_Cliente = O.Id_Cliente
							JOIN #Total_Contratos Z ON L.Id_Cliente_Ref = Z.Id_Cliente
							LEFT JOIN Contratos_Tipos_Prod C ON O.Id_Tipo_Con = C.Id_Tipo_Con
							LEFT JOIN Productos P ON C.Id_Producto = P.Id_Producto
							LEFT JOIN #Z_Productos_Facturados Z1 ON P.Id_Producto  = Z1.Id_Producto AND L.ID_CLIENTE = Z1.Id_Cliente
							LEFT JOIN #Ult_Fech_Fac UF ON UF.Id_Contrato = O.Id_Contrato
						WHERE O.Activo = 1
							AND L.Activo = 1
							AND O.Id_Tipo_Con = @pId_Tipo_Cont
							AND C.Id_Producto <> ''
							AND Z1.Id_Producto IS NULL
							AND ( O.Fecha_Hasta >= DATEADD(DAY,1,@pFecha_Desde) OR O.Fecha_Hasta IS NULL)           
												AND O.Fecha_Desde < DATEADD(DAY,1,@pFecha_Hasta)     
												AND (O.Fecha_Cob_Hasta < DATEADD(DAY,1,@pFecha_Hasta) OR O.Fecha_Cob_Hasta IS NULL)
						ORDER BY L.Id_Cliente_Ref
			END
		END
		ELSE -- IF(@pRefacturar <> 1)
		BEGIN
			INSERT INTO #Total_Contratos_Items
			SELECT P.Id_Producto, Z.ID_TIEMPO, Z.Id_Cliente, 
					Z.Id_Contrato,(dbo.CF_Produc_Precio(P.Id_Producto, Z.Id_Cliente, @pFecha_QA, Z.Id_Contrato, 0,  'B')) AS Precio_Item, C.Cantidad,
					0 AS Id_Trans_Remito, Z.Id_Cliente_Ref, Z.Id_Lista_Precio, UF.Ult_Fecha_Fact, P.Flag_Mes_Desglo, ISNULL(P.Id_Cond_Pago,@Cond_Pago_Lote)	
					FROM Contratos_Tipos_Prod C
						LEFT JOIN Productos P ON C.Id_Producto  = P.Id_Producto 
						JOIN #Total_Contratos Z ON C.Id_Tipo_Con = Z.Id_Tipo_Con
						LEFT JOIN #Ult_Fech_Fac UF ON UF.Id_Contrato = Z.Id_Contrato
					WHERE C.Id_Producto <> ''

			IF(@Flag_Agru_Cli_Ref = 1)
			BEGIN
				INSERT INTO #Total_Contratos_Items
				SELECT P.Id_Producto, Z.ID_TIEMPO, L.Id_Cliente, 
						Z.Id_Contrato,(dbo.CF_Produc_Precio(P.Id_Producto, O.Id_Cliente, @pFecha_QA, O.Id_Contrato, 0,  'B')) AS Precio_Item, C.Cantidad,
						0 AS Id_Trans_Remito, Z.Id_Cliente_Ref, Z.Id_Lista_Precio, UF.Ult_Fecha_Fact, P.Flag_Mes_Desglo, ISNULL(P.Id_Cond_Pago,@Cond_Pago_Lote)	
						FROM Contratos O
							LEFT JOIN Clientes L ON L.Id_Cliente = O.Id_Cliente
							JOIN #Total_Contratos Z ON L.Id_Cliente_Ref = Z.Id_Cliente
							LEFT JOIN Contratos_Tipos_Prod C ON O.Id_Tipo_Con = C.Id_Tipo_Con
							LEFT JOIN Productos P ON C.Id_Producto = P.Id_Producto
							LEFT JOIN #Ult_Fech_Fac UF ON UF.Id_Contrato = O.Id_Contrato
						WHERE O.Activo = 1
						AND L.Activo = 1
						AND O.Id_Tipo_Con = @pId_Tipo_Cont
						AND C.Id_Producto <> ''
						AND ( O.Fecha_Hasta >= DATEADD(DAY,1,@pFecha_Desde) OR O.Fecha_Hasta IS NULL)           
											AND O.Fecha_Desde < DATEADD(DAY,1,@pFecha_Hasta)     
											AND (O.Fecha_Cob_Hasta < DATEADD(DAY,1,@pFecha_Hasta) OR O.Fecha_Cob_Hasta IS NULL)
						ORDER BY L.Id_Cliente_Ref
			END
		END

		IF @pModoDebug <> 0	
		BEGIN
			PRINT 'Agregue en  #Total_Contratos_Items de Contratros_Tipos_Prod. Hora Ejecucion: ' + CONVERT(VARCHAR(25),GETDATE())	
		END

		IF(@pRefacturar <> 1)
		BEGIN
			INSERT INTO #Total_Contratos_Items
			SELECT P.Id_Producto, Z.ID_TIEMPO, Z.Id_Cliente, 
						Z.Id_Contrato,(dbo.CF_Produc_Precio(P.Id_Producto, Z.Id_Cliente, @pFecha_QA, Z.Id_Contrato, 0,  'B')) AS Precio_Item, 1,
						0 AS Id_Trans_Remito, Z.Id_Cliente_Ref, Z.Id_Lista_Precio, UF.Ult_Fecha_Fact, P.Flag_Mes_Desglo, ISNULL(P.Id_Cond_Pago,@Cond_Pago_Lote)	
						FROM Contratos_Prod C
							LEFT JOIN Productos P ON C.Id_Producto  = P.Id_Producto 
							JOIN #Total_Contratos Z ON C.Id_Contrato = Z.Id_Contrato
							LEFT JOIN #Z_Productos_Facturados Z1 ON P.Id_Producto  = Z1.Id_Producto  AND Z.ID_CLIENTE = Z1.Id_Cliente
							LEFT JOIN #Ult_Fech_Fac UF ON UF.Id_Contrato = Z.Id_Contrato
						WHERE C.Flag_Facturable = 1
							AND C.Id_Producto <> ''
							AND Z1.Id_Producto IS NULL

			IF(@Flag_Agru_Cli_Ref = 1)
			BEGIN
				INSERT INTO #Total_Contratos_Items
				SELECT P.Id_Producto, Z.ID_TIEMPO, L.Id_Cliente, 
						Z.Id_Contrato,(dbo.CF_Produc_Precio(P.Id_Producto, O.Id_Cliente, @pFecha_QA, O.Id_Contrato, 0,  'B')) AS Precio_Item, 1,
						0 AS Id_Trans_Remito, L.Id_Cliente_Ref, Z.Id_Lista_Precio, UF.Ult_Fecha_Fact, P.Flag_Mes_Desglo, ISNULL(P.Id_Cond_Pago,@Cond_Pago_Lote)		
						FROM Contratos O
							LEFT JOIN Clientes L ON L.Id_Cliente = O.Id_Cliente
							JOIN #Total_Contratos Z ON L.Id_Cliente_Ref = Z.Id_Cliente
							LEFT JOIN Contratos_Prod CP ON O.Id_Contrato = CP.Id_Contrato
							LEFT JOIN Productos P ON CP.Id_Producto = P.Id_Producto
							LEFT JOIN #Z_Productos_Facturados Z1 ON P.Id_Producto  = Z1.Id_Producto AND L.ID_CLIENTE = Z1.Id_Cliente
							LEFT JOIN #Ult_Fech_Fac UF ON UF.Id_Contrato = O.Id_Contrato
						WHERE CP.Flag_Facturable = 1
						AND O.Activo = 1
						AND L.Activo = 1
						AND O.Id_Tipo_Con = @pId_Tipo_Cont
						AND CP.Id_Producto <> ''
						AND Z1.Id_Producto IS NULL
						AND ( O.Fecha_Hasta >= DATEADD(DAY,1,@pFecha_Desde) OR O.Fecha_Hasta IS NULL)           
											AND O.Fecha_Desde < DATEADD(DAY,1,@pFecha_Hasta)     
											AND (O.Fecha_Cob_Hasta < DATEADD(DAY,1,@pFecha_Hasta) OR O.Fecha_Cob_Hasta IS NULL)
			END
		END
		ELSE -- IF(@pRefacturar <> 1)
		BEGIN
			INSERT INTO #Total_Contratos_Items
			SELECT P.Id_Producto, Z.ID_TIEMPO, Z.Id_Cliente, 
						Z.Id_Contrato,(dbo.CF_Produc_Precio(P.Id_Producto, Z.Id_Cliente, @pFecha_QA, Z.Id_Contrato, 0, 'B')) AS Precio_Item, 1,
						0 AS Id_Trans_Remito, Z.Id_Cliente_Ref, Z.Id_Lista_Precio, UF.Ult_Fecha_Fact, P.Flag_Mes_Desglo, ISNULL(P.Id_Cond_Pago,@Cond_Pago_Lote)	
						FROM Contratos_Prod C
							LEFT JOIN Productos P ON C.Id_Producto  = P.Id_Producto 
							JOIN #Total_Contratos Z ON C.Id_Contrato = Z.Id_Contrato
							LEFT JOIN #Ult_Fech_Fac UF ON UF.Id_Contrato = Z.Id_Contrato
						WHERE C.Flag_Facturable = 1
							AND C.Id_Producto <> ''

			IF(@Flag_Agru_Cli_Ref = 1)
			BEGIN
				INSERT INTO #Total_Contratos_Items
				SELECT P.Id_Producto, Z.ID_TIEMPO, L.Id_Cliente, 
						Z.Id_Contrato,(dbo.CF_Produc_Precio(P.Id_Producto, O.Id_Cliente, @pFecha_QA, O.Id_Contrato, 0, 'B')) AS Precio_Item, 1,
						0 AS Id_Trans_Remito, L.Id_Cliente_Ref, Z.Id_Lista_Precio, UF.Ult_Fecha_Fact, P.Flag_Mes_Desglo, ISNULL(P.Id_Cond_Pago,@Cond_Pago_Lote)	
						FROM Contratos O
							LEFT JOIN Clientes L ON L.Id_Cliente = O.Id_Cliente
							JOIN #Total_Contratos Z ON L.Id_Cliente_Ref = Z.Id_Cliente
							LEFT JOIN Contratos_Prod CP ON O.Id_Contrato = CP.Id_Contrato
							LEFT JOIN Productos P ON CP.Id_Producto = P.Id_Producto
							LEFT JOIN #Ult_Fech_Fac UF ON UF.Id_Contrato = O.Id_Contrato
						WHERE CP.Flag_Facturable = 1
						AND O.Activo = 1
						AND L.Activo = 1
						AND O.Id_Tipo_Con = @pId_Tipo_Cont
						AND CP.Id_Producto <> ''
						AND ( O.Fecha_Hasta >= DATEADD(DAY,1,@pFecha_Desde) OR O.Fecha_Hasta IS NULL)           
											AND O.Fecha_Desde < DATEADD(DAY,1,@pFecha_Hasta)     
											AND (O.Fecha_Cob_Hasta < DATEADD(DAY,1,@pFecha_Hasta) OR O.Fecha_Cob_Hasta IS NULL)
			END
		END
	END 
	ELSE-- IF(@Id_Producto_Bonif <> '')
	BEGIN
		-- Creo tabla #Total_Contratos_Cbtes con filtros por uni de tiempo y productos
		IF(@pRefacturar <> 1)
		BEGIN
			INSERT INTO #Total_Contratos_Items
			SELECT P.Id_Producto, Z.ID_TIEMPO, Z.Id_Cliente, 
					Z.Id_Contrato, CASE 
									WHEN Z.Porc_Bonif <> 0 THEN (dbo.CF_Produc_Precio(P.Id_Producto, Z.Id_Cliente, @pFecha_QA, Z.Id_Contrato, Z.Porc_Bonif,  'B'))
									ELSE CASE 
											WHEN Z.Imp_Bonif <> 0 THEN dbo.CF_Produc_Precio(P.Id_Producto, Z.Id_Cliente, @pFecha_QA, Z.Id_Contrato, 0,  'B') - Z.Imp_Bonif
											ELSE dbo.CF_Produc_Precio(P.Id_Producto, Z.Id_Cliente, @pFecha_QA, Z.Id_Contrato, 0,  'B') 
										 END
									END AS Precio_Item,  
					C.Cantidad, 0 AS Id_Trans_Remito, Z.Id_Cliente_Ref, Z.Id_Lista_Precio, UF.Ult_Fecha_Fact, P.Flag_Mes_Desglo, ISNULL(P.Id_Cond_Pago,@Cond_Pago_Lote)				
					FROM Contratos_Tipos_Prod C
						LEFT JOIN Productos P ON C.Id_Producto  = P.Id_Producto 
						JOIN #Total_Contratos Z ON C.Id_Tipo_Con = Z.Id_Tipo_Con
						LEFT JOIN #Z_Productos_Facturados Z1 ON P.Id_Producto  = Z1.Id_Producto  AND Z.ID_CLIENTE = Z1.Id_Cliente
						JOIN #Ult_Fech_Fac UF ON UF.Id_Contrato = Z.Id_Contrato
					WHERE C.Id_Producto <> '' AND Z1.Id_Cliente IS NULL

			IF(@Flag_Agru_Cli_Ref = 1)
			BEGIN
				INSERT INTO #Total_Contratos_Items
				SELECT P.Id_Producto, Z.ID_TIEMPO, L.Id_Cliente, 
						Z.Id_Contrato,CASE 
										WHEN O.Porc_Bonif <> 0 THEN (dbo.CF_Produc_Precio(P.Id_Producto, O.Id_Cliente, @pFecha_QA, O.Id_Contrato, O.Porc_Bonif,  'B'))
										ELSE CASE 
												WHEN O.Imp_Bonif <> 0 THEN dbo.CF_Produc_Precio(P.Id_Producto, O.Id_Cliente, @pFecha_QA, O.Id_Contrato, 0,  'B') - O.Imp_Bonif
												ELSE dbo.CF_Produc_Precio(P.Id_Producto, O.Id_Cliente, @pFecha_QA, O.Id_Contrato, 0,  'B') 
											 END
										END AS Precio_Item,    
						C.Cantidad, 0 AS Id_Trans_Remito, Z.Id_Cliente_Ref, Z.Id_Lista_Precio, UF.Ult_Fecha_Fact, P.Flag_Mes_Desglo, ISNULL(P.Id_Cond_Pago,@Cond_Pago_Lote)		
						FROM Contratos O
							LEFT JOIN Clientes L ON L.Id_Cliente = O.Id_Cliente
							JOIN #Total_Contratos Z ON L.Id_Cliente_Ref = Z.Id_Cliente
							LEFT JOIN Contratos_Tipos_Prod C ON O.Id_Tipo_Con = C.Id_Tipo_Con
							LEFT JOIN Productos P ON C.Id_Producto = P.Id_Producto
							LEFT JOIN #Z_Productos_Facturados Z1 ON P.Id_Producto  = Z1.Id_Producto AND L.ID_CLIENTE = Z1.Id_Cliente
							LEFT JOIN #Ult_Fech_Fac UF ON UF.Id_Contrato = O.Id_Contrato
						WHERE O.Activo = 1
							AND L.Activo = 1
							AND O.Id_Tipo_Con = @pId_Tipo_Cont
							AND C.Id_Producto <> ''
							AND Z1.Id_Producto IS NULL
							AND ( O.Fecha_Hasta >= DATEADD(DAY,1,@pFecha_Desde) OR O.Fecha_Hasta IS NULL)           
												AND O.Fecha_Desde < DATEADD(DAY,1,@pFecha_Hasta)     
												AND (O.Fecha_Cob_Hasta < DATEADD(DAY,1,@pFecha_Hasta) OR O.Fecha_Cob_Hasta IS NULL)
						ORDER BY L.Id_Cliente_Ref
			END
		END
		ELSE -- IF(@pRefacturar <> 1)
		BEGIN
			INSERT INTO #Total_Contratos_Items
			SELECT P.Id_Producto, Z.ID_TIEMPO, Z.Id_Cliente, 
					Z.Id_Contrato, CASE 
									WHEN Z.Porc_Bonif <> 0 THEN (dbo.CF_Produc_Precio(P.Id_Producto, Z.Id_Cliente, @pFecha_QA, Z.Id_Contrato, Z.Porc_Bonif,  'B'))
									ELSE CASE 
											WHEN Z.Imp_Bonif <> 0 THEN dbo.CF_Produc_Precio(P.Id_Producto, Z.Id_Cliente, @pFecha_QA, Z.Id_Contrato, 0,  'B') - Z.Imp_Bonif
											ELSE dbo.CF_Produc_Precio(P.Id_Producto, Z.Id_Cliente, @pFecha_QA, Z.Id_Contrato, 0,  'B') 
										 END
									END AS Precio_Item, 
					C.Cantidad, 0 AS Id_Trans_Remito, Z.Id_Cliente_Ref, Z.Id_Lista_Precio, UF.Ult_Fecha_Fact, P.Flag_Mes_Desglo, ISNULL(P.Id_Cond_Pago,@Cond_Pago_Lote)
					FROM Contratos_Tipos_Prod C
						LEFT JOIN Productos P ON C.Id_Producto  = P.Id_Producto 
						JOIN #Total_Contratos Z ON C.Id_Tipo_Con = Z.Id_Tipo_Con
						LEFT JOIN #Ult_Fech_Fac UF ON UF.Id_Contrato = Z.Id_Contrato
					WHERE C.Id_Producto <> ''

			IF(@Flag_Agru_Cli_Ref = 1)
			BEGIN
				INSERT INTO #Total_Contratos_Items
				SELECT P.Id_Producto, Z.ID_TIEMPO, L.Id_Cliente, 
						Z.Id_Contrato,CASE 
										WHEN O.Porc_Bonif <> 0 THEN (dbo.CF_Produc_Precio(P.Id_Producto, O.Id_Cliente, @pFecha_QA, O.Id_Contrato, O.Porc_Bonif,  'B'))
										ELSE CASE 
												WHEN O.Imp_Bonif <> 0 THEN dbo.CF_Produc_Precio(P.Id_Producto, O.Id_Cliente, @pFecha_QA, O.Id_Contrato, 0,  'B') - O.Imp_Bonif
												ELSE dbo.CF_Produc_Precio(P.Id_Producto, O.Id_Cliente, @pFecha_QA, O.Id_Contrato, 0,  'B') 
											 END
										END AS Precio_Item,  
						C.Cantidad, 0 AS Id_Trans_Remito, Z.Id_Cliente_Ref, Z.Id_Lista_Precio, UF.Ult_Fecha_Fact, P.Flag_Mes_Desglo, ISNULL(P.Id_Cond_Pago,@Cond_Pago_Lote)	
						FROM Contratos O
							LEFT JOIN Clientes L ON L.Id_Cliente = O.Id_Cliente
							JOIN #Total_Contratos Z ON L.Id_Cliente_Ref = Z.Id_Cliente
							LEFT JOIN Contratos_Tipos_Prod C ON O.Id_Tipo_Con = C.Id_Tipo_Con
							LEFT JOIN Productos P ON C.Id_Producto = P.Id_Producto
							LEFT JOIN #Ult_Fech_Fac UF ON UF.Id_Contrato = O.Id_Contrato
						WHERE O.Activo = 1
						AND L.Activo = 1
						AND O.Id_Tipo_Con = @pId_Tipo_Cont
						AND C.Id_Producto <> ''
						AND ( O.Fecha_Hasta >= DATEADD(DAY,1,@pFecha_Desde) OR O.Fecha_Hasta IS NULL)           
											AND O.Fecha_Desde < DATEADD(DAY,1,@pFecha_Hasta)     
											AND (O.Fecha_Cob_Hasta < DATEADD(DAY,1,@pFecha_Hasta) OR O.Fecha_Cob_Hasta IS NULL)
						ORDER BY L.Id_Cliente_Ref
			END
		END

		IF @pModoDebug <> 0	
		BEGIN
			PRINT 'Agregue en  #Total_Contratos_Items de Contratos_Tipos_Prod. Hora Ejecucion: ' + CONVERT(VARCHAR(25),GETDATE())	
		END

		IF(@pRefacturar <> 1)
		BEGIN
			INSERT INTO #Total_Contratos_Items
			SELECT P.Id_Producto, Z.ID_TIEMPO, Z.Id_Cliente, 
						Z.Id_Contrato,CASE 
										WHEN Z.Porc_Bonif <> 0 THEN (dbo.CF_Produc_Precio(P.Id_Producto, Z.Id_Cliente, @pFecha_QA, Z.Id_Contrato, Z.Porc_Bonif,  'B'))
										ELSE CASE 
												WHEN Z.Imp_Bonif <> 0 THEN dbo.CF_Produc_Precio(P.Id_Producto, Z.Id_Cliente, @pFecha_QA, Z.Id_Contrato, 0,  'B') - Z.Imp_Bonif
												ELSE dbo.CF_Produc_Precio(P.Id_Producto, Z.Id_Cliente, @pFecha_QA, Z.Id_Contrato, 0,  'B') 
											 END
									END AS Precio_Item, 
						1, 0 AS Id_Trans_Remito, Z.Id_Cliente_Ref, Z.Id_Lista_Precio, UF.Ult_Fecha_Fact, P.Flag_Mes_Desglo, ISNULL(P.Id_Cond_Pago,@Cond_Pago_Lote)	
						FROM Contratos_Prod C
							LEFT JOIN Productos P ON C.Id_Producto  = P.Id_Producto 
							JOIN #Total_Contratos Z ON C.Id_Contrato = Z.Id_Contrato
							LEFT JOIN #Z_Productos_Facturados Z1 ON P.Id_Producto  = Z1.Id_Producto  AND Z.ID_CLIENTE = Z1.Id_Cliente
							LEFT JOIN #Ult_Fech_Fac UF ON UF.Id_Contrato = Z.Id_Contrato
						WHERE C.Flag_Facturable = 1
							AND C.Id_Producto <> ''
							AND Z1.Id_Producto IS NULL

			IF(@Flag_Agru_Cli_Ref = 1)
			BEGIN
				INSERT INTO #Total_Contratos_Items
				SELECT P.Id_Producto, Z.ID_TIEMPO, L.Id_Cliente, 
						Z.Id_Contrato,CASE 
										WHEN O.Porc_Bonif <> 0 THEN (dbo.CF_Produc_Precio(P.Id_Producto, O.Id_Cliente, @pFecha_QA, O.Id_Contrato, O.Porc_Bonif,  'B'))
										ELSE CASE 
												WHEN O.Imp_Bonif <> 0 THEN dbo.CF_Produc_Precio(P.Id_Producto, O.Id_Cliente, @pFecha_QA, O.Id_Contrato, 0,  'B') - O.Imp_Bonif
												ELSE dbo.CF_Produc_Precio(P.Id_Producto, O.Id_Cliente, @pFecha_QA, O.Id_Contrato, 0,  'B') 
											 END
										END AS Precio_Item,  
						1, 0 AS Id_Trans_Remito, L.Id_Cliente_Ref, Z.Id_Lista_Precio, UF.Ult_Fecha_Fact, P.Flag_Mes_Desglo, ISNULL(P.Id_Cond_Pago,@Cond_Pago_Lote)	
						FROM Contratos O
							LEFT JOIN Clientes L ON L.Id_Cliente = O.Id_Cliente
							JOIN #Total_Contratos Z ON L.Id_Cliente_Ref = Z.Id_Cliente
							LEFT JOIN Contratos_Prod CP ON O.Id_Contrato = CP.Id_Contrato
							LEFT JOIN Productos P ON CP.Id_Producto = P.Id_Producto
							LEFT JOIN #Z_Productos_Facturados Z1 ON P.Id_Producto  = Z1.Id_Producto AND L.ID_CLIENTE = Z1.Id_Cliente
							LEFT JOIN #Ult_Fech_Fac UF ON UF.Id_Contrato = O.Id_Contrato
						WHERE CP.Flag_Facturable = 1
						AND O.Activo = 1
						AND L.Activo = 1
						AND O.Id_Tipo_Con = @pId_Tipo_Cont
						AND CP.Id_Producto <> ''
						AND Z1.Id_Producto IS NULL
						AND ( O.Fecha_Hasta >= DATEADD(DAY,1,@pFecha_Desde) OR O.Fecha_Hasta IS NULL)           
											AND O.Fecha_Desde < DATEADD(DAY,1,@pFecha_Hasta)     
											AND (O.Fecha_Cob_Hasta < DATEADD(DAY,1,@pFecha_Hasta) OR O.Fecha_Cob_Hasta IS NULL)
			END
		END
		ELSE -- IF(@pRefacturar <> 1)
		BEGIN
			INSERT INTO #Total_Contratos_Items
			SELECT P.Id_Producto, Z.ID_TIEMPO, Z.Id_Cliente, 
						Z.Id_Contrato,CASE 
										WHEN Z.Porc_Bonif <> 0 THEN (dbo.CF_Produc_Precio(P.Id_Producto, Z.Id_Cliente, @pFecha_QA, Z.Id_Contrato, Z.Porc_Bonif,  'B'))
										ELSE CASE 
												WHEN Z.Imp_Bonif <> 0 THEN dbo.CF_Produc_Precio(P.Id_Producto, Z.Id_Cliente, @pFecha_QA, Z.Id_Contrato, 0,  'B') - Z.Imp_Bonif
												ELSE dbo.CF_Produc_Precio(P.Id_Producto, Z.Id_Cliente, @pFecha_QA, Z.Id_Contrato, 0,  'B') 
											 END
									  END AS Precio_Item,   
						1, 0 AS Id_Trans_Remito, Z.Id_Cliente_Ref, Z.Id_Lista_Precio, UF.Ult_Fecha_Fact, P.Flag_Mes_Desglo, ISNULL(P.Id_Cond_Pago,@Cond_Pago_Lote)	
						FROM Contratos_Prod C
							LEFT JOIN Productos P ON C.Id_Producto  = P.Id_Producto 
							JOIN #Total_Contratos Z ON C.Id_Contrato = Z.Id_Contrato
							LEFT JOIN #Ult_Fech_Fac UF ON UF.Id_Contrato = Z.Id_Contrato
						WHERE C.Flag_Facturable = 1
							AND C.Id_Producto <> ''

			IF(@Flag_Agru_Cli_Ref = 1)
			BEGIN
				INSERT INTO #Total_Contratos_Items
				SELECT P.Id_Producto, Z.ID_TIEMPO, L.Id_Cliente, 
						Z.Id_Contrato,CASE 
										WHEN O.Porc_Bonif <> 0 THEN (dbo.CF_Produc_Precio(P.Id_Producto, O.Id_Cliente, @pFecha_QA, O.Id_Contrato, O.Porc_Bonif,  'B'))
										ELSE CASE 
												WHEN O.Imp_Bonif <> 0 THEN dbo.CF_Produc_Precio(P.Id_Producto, O.Id_Cliente, @pFecha_QA, O.Id_Contrato, 0,  'B') - O.Imp_Bonif
												ELSE dbo.CF_Produc_Precio(P.Id_Producto, O.Id_Cliente, @pFecha_QA, O.Id_Contrato, 0,  'B') 
											 END
										END AS Precio_Item,  
						1, 0 AS Id_Trans_Remito, L.Id_Cliente_Ref, Z.Id_Lista_Precio, UF.Ult_Fecha_Fact, P.Flag_Mes_Desglo, ISNULL(P.Id_Cond_Pago,@Cond_Pago_Lote)	
						FROM Contratos O
							LEFT JOIN Clientes L ON L.Id_Cliente = O.Id_Cliente
							JOIN #Total_Contratos Z ON L.Id_Cliente_Ref = Z.Id_Cliente
							LEFT JOIN Contratos_Prod CP ON O.Id_Contrato = CP.Id_Contrato
							LEFT JOIN Productos P ON CP.Id_Producto = P.Id_Producto
							LEFT JOIN #Ult_Fech_Fac UF ON UF.Id_Contrato = O.Id_Contrato
						WHERE CP.Flag_Facturable = 1
						AND O.Activo = 1
						AND L.Activo = 1
						AND O.Id_Tipo_Con = @pId_Tipo_Cont
						AND CP.Id_Producto <> ''
						AND ( O.Fecha_Hasta >= DATEADD(DAY,1,@pFecha_Desde) OR O.Fecha_Hasta IS NULL)           
											AND O.Fecha_Desde < DATEADD(DAY,1,@pFecha_Hasta)     
											AND (O.Fecha_Cob_Hasta < DATEADD(DAY,1,@pFecha_Hasta) OR O.Fecha_Cob_Hasta IS NULL)
			END
		END
	END
	
	SET @Generar_Tabla_Desc = ISNULL((SELECT TOP 1 1 FROM #Total_Contratos WHERE Porc_Bonif <> 0 OR Imp_Bonif <> 0),0)
	SET @Id_Producto_Bonif_Cond_Pago = ISNULL((SELECT TOP 1 Id_Cond_Pago FROM Productos WHERE Id_Producto = @Id_Producto_Bonif),0)

	--PRINT @Id_Producto_Bonif
	
	IF(@Id_Producto_Bonif <> '' AND @Generar_Tabla_Desc = 1)
	BEGIN
		INSERT INTO #Total_Contratos_Items
		SELECT @Id_Producto_Bonif, I.ID_TIEMPO, I.Id_Cliente, 
				I.Id_Contrato,
				CASE 
					WHEN T.Porc_Bonif <> 0 THEN (dbo.CF_Produc_Precio(I.Id_Producto, I.Id_Cliente, @pFecha_QA, I.Id_Contrato, 0,  'B')) * (T.Porc_Bonif/100) * -1
					WHEN T.Imp_Bonif <> 0 THEN T.Imp_Bonif  * -1
				END AS Precio_Item,
				I.Cantidad, I.Id_Trans_Remito, I.Id_Cliente_Ref, I.Id_Lista_Precio, NULL AS Ult_Fecha_Fact, I.Flag_Mes_Desglo,ISNULL(@Id_Producto_Bonif_Cond_Pago,@Cond_Pago_Lote)	
				FROM #Total_Contratos_Items I
					LEFT JOIN #Total_Contratos T ON I.Id_Contrato = T.Id_Contrato
					LEFT JOIN Productos P ON @Id_Producto_Bonif = P.Id_Producto
					WHERE (T.Porc_Bonif <> 0 OR T.Imp_Bonif <> 0)
	END
	
	IF @pModoDebug <> 0	
	BEGIN
		PRINT 'Agregue en  #Total_Contratos_Items de Contratros_Prod. Hora Ejecucion: ' + CONVERT(VARCHAR(25),GETDATE())		
	END

	-- Agrego cualquier remito pendiente de facturacion de clientes de #Total_Contratos
	IF @Procesa_Remitos = 1
	BEGIN	
		INSERT INTO #Total_Contratos_Items												
			SELECT CI.Id_Producto, '', CB.Id_Cliente, Z.Id_Contrato, CI.Precio_Grav AS Precio_Item, CI.Cantidad, 
					CB.Id_Trans AS Id_Trans_Remito, Z.Id_Cliente_Ref, CB.Id_Lista, NULL AS Ult_Fecha_Fact, P.Flag_Mes_Desglo, ISNULL(P.Id_Cond_Pago,@Cond_Pago_Lote)		
							FROM Cbtes CB
								JOIN Cbtes_Items CI ON CB.Id_Trans = CI.Id_Trans
								JOIN Cbtes_Tipos CT ON CB.Id_Tipo_Cbte = CT.Id_Tipo_Cbte
								JOIN #Total_Contratos Z ON CB.Id_Cliente = Z.Id_Cliente
								JOIN Productos P ON CI.Id_Producto  = P.Id_Producto 
							WHERE CI.Id_Producto <> ''
								AND CT.Compromete_Remitos IN (1)
								AND CB.Id_Estado_Cbte = 1
								AND CONVERT(DATE, CB.Fecha) >= CONVERT(DATE, @pFecha_Rem_Desde)
								AND CONVERT(DATE, CB.Fecha) <= CONVERT(DATE, @pFecha_Rem_Hasta)

		IF(@Flag_Agru_Cli_Ref = 1)
		BEGIN
			INSERT INTO #Total_Contratos_Items		
			SELECT CI.Id_Producto, '', CB.Id_Cliente, Z.Id_Contrato, CI.Precio_Grav AS Precio_Item, CI.Cantidad, 
					CB.Id_Trans AS Id_Trans_Remito, Z.Id_Cliente_Ref, CB.Id_Lista, NULL AS Ult_Fecha_Fact, P.Flag_Mes_Desglo, ISNULL(P.Id_Cond_Pago,@Cond_Pago_Lote)		
							FROM Cbtes CB
								LEFT JOIN Clientes L ON L.Id_Cliente = CB.Id_Cliente
								JOIN Cbtes_Items CI ON CB.Id_Trans = CI.Id_Trans
								JOIN Cbtes_Tipos CT ON CB.Id_Tipo_Cbte = CT.Id_Tipo_Cbte
								JOIN #Total_Contratos Z ON L.Id_Cliente_Ref = Z.Id_Cliente
								JOIN Productos P ON CI.Id_Producto  = P.Id_Producto 
							WHERE CI.Id_Producto <> ''
								AND CT.Compromete_Remitos IN (1)
								AND CB.Id_Estado_Cbte = 1
								AND CONVERT(DATE, CB.Fecha) >= CONVERT(DATE, @pFecha_Rem_Desde)
								AND CONVERT(DATE, CB.Fecha) <= CONVERT(DATE, @pFecha_Rem_Hasta)

		END
		
		SELECT Id_Trans_Remito INTO #Remitos_Fact FROM #Total_Contratos_Items WHERE Id_Trans_Remito <> 0

        IF @pModoDebug <> 0	
		BEGIN
			PRINT 'Agregue en  #Total_Contratos_Items de Remitos. Hora Ejecucion: ' + CONVERT(VARCHAR(25),GETDATE())
		END
	END

	-- Genero tabla para filtro por uni de tiempo
	SELECT Z.Id_Contrato 
			INTO #Cont_Tiempo 
			FROM #Total_Contratos_Items Z, Tab_Uni_Tiempo T 
			WHERE Z.Id_Tiempo COLLATE SQL_Latin1_General_CP1_CI_AS = T.Id_Tiempo COLLATE SQL_Latin1_General_CP1_CI_AS 
					AND Z.Ult_Fecha_Fact IS NOT NULL
					--AND (Z.Id_Tiempo <> '' OR (SELECT ISNULL(Tipo,'M') FROM Tab_Uni_Tiempo WHERE Id_Tiempo = Z.Id_Tiempo) <> 'M')
					AND CONVERT(VARCHAR(25),(CASE T.Tipo
													WHEN 'D' THEN DATEADD(DAY,T.Cantidad,Z.Ult_Fecha_Fact)
													WHEN 'M' THEN DATEADD(MONTH,T.Cantidad,Z.Ult_Fecha_Fact)
													WHEN 'A' THEN DATEADD(YEAR,T.Cantidad,Z.Ult_Fecha_Fact)
												END),112) > CONVERT(VARCHAR(25),@pFecha_QA,112)

	DELETE FROM #Total_Contratos_Items WHERE Id_Contrato IN (SELECT Id_Contrato FROM #Cont_Tiempo) 

	IF @pModoDebug <> 0	
	BEGIN
		PRINT 'Agregue en  #Cont_Tiempo. Hora Ejecucion: ' + CONVERT(VARCHAR(25),GETDATE())
	END

	-- Calculo el total del contrato
	SELECT Z.Id_Contrato, Z.ID_TIEMPO, SUM((Z.Precio_Item * Z.Cantidad)) AS Precio_Cont
		INTO #Total_Contratos_Cbtes
		FROM #Total_Contratos_Items Z
		GROUP BY Z.Id_Contrato, Z.ID_TIEMPO
		ORDER BY Z.Id_Contrato

	IF @pModoDebug <> 0	
	BEGIN
		PRINT 'Agregue en  #Total_Contratos_Cbtes. Hora Ejecucion: ' + CONVERT(VARCHAR(25),GETDATE())
	END
	
	-- Elimino los contratos en cero (si no se deben facturar)
	IF(@pIncl_Cbtes_Cero = 0)
	BEGIN
		DELETE FROM #Total_Contratos_Cbtes WHERE Precio_Cont = 0
		DELETE #Total_Contratos_Items FROM #Total_Contratos_Items AS C WHERE NOT EXISTS (SELECT * FROM #Total_Contratos_Cbtes P WHERE P.Id_Contrato = C.Id_Contrato) AND Id_Trans_Remito = 0

		IF @pModoDebug <> 0	
		BEGIN
			PRINT 'Borre contratos en cero de  #Total_Contratos_Cbtes. Hora Ejecucion: ' + CONVERT(VARCHAR(25),GETDATE())
		END
	END

	-- Agrego las transacciones en tabla Transacciones
	SET @Prox_Trans = (SELECT MAX(ID_TRANS) + 1 FROM Transacciones)

	SET @AlterTable = 'ALTER TABLE #Total_Contratos_Cbtes 
					    ADD Id_Trans_Facturar INT IDENTITY(' + CAST(@Prox_Trans AS VARCHAR) + ', 1);'

	EXEC (@AlterTable)
	INSERT INTO Transacciones
		SELECT Id_Trans_Facturar,NULL,GETDATE(),-1 FROM #Total_Contratos_Cbtes

	IF @pModoDebug <> 0	
	BEGIN
		PRINT 'Agregue Transacciones. Hora Ejecucion: ' + CONVERT(VARCHAR(25),GETDATE())		
	END

	-- Genero tabla Cbtes_Insert con datos para la cabecera de Cbtes
	SELECT 	P.*, CT.Id_Sucursal, O.Id_Tipo_Cbte, L.Id_Cliente,  CASE 
																	WHEN L.Id_Cliente_Ref <> 0 THEN L.Id_Cliente_Ref 
																	ELSE L.Id_Cliente 
																END AS Id_Cliente_Ref,
						@Cond_Pago_Lote as Cond_Pago_Cbte, L.Razon_Social, L.Cuit, L.Id_IVA,		
						L.Id_Cobrador, L.Email, CASE 
													WHEN O.Id_Lista_Precio IS NULL OR O.Id_Lista_Precio = 0 THEN L.Id_Lista_Precio
													ELSE O.Id_Lista_Precio 
												END AS Id_Lista_Precio,
												CASE P.Precio_Cont
													WHEN 0 THEN 2
													ELSE CT.Id_Estado_Cbte
												END AS Id_Estado_Cbte,
					RANK () OVER (PARTITION BY CT.Id_Tipo_Cbte ORDER BY P.Id_Contrato) + CT.Prox_Nro AS Nro_Cbte,
					dbo.CF_Cbtes_Descrip_SinTrans(RANK () OVER (PARTITION BY CT.Id_Tipo_Cbte ORDER BY P.Id_Contrato) + CT.Prox_Nro, CT.Descrip_Corta, CT.Letra, CT.Id_Sucursal,@pCant_Dig_Cbtes, CT.Compromete_Remitos, @pCant_Dig_Rem, CT.Id_Sucursal, CT.Compromete_Compras) AS Cbte_Descrip		
					INTO #Cbtes_Insert
					FROM #Total_Contratos_Cbtes P
							LEFT JOIN Contratos O ON O.Id_Contrato = P.Id_Contrato
							LEFT JOIN Clientes L ON O.Id_Cliente = L.Id_Cliente
							LEFT JOIN Cbtes_Tipos CT ON O.Id_Tipo_Cbte = CT.Id_Tipo_Cbte
							ORDER BY P.Id_Contrato
	
	IF @pModoDebug <> 0	
	BEGIN
		PRINT 'Agregue #Cbtes_Insert. Hora Ejecucion: ' + CONVERT(VARCHAR(25),GETDATE())
	END

	-- Actualizo Nro de Cbtes a ingresar y actualizo campo Prox_Nro en ficha de cbtes a ingresar
	;with temp as (
    SELECT Id_Tipo_Cbte, Prox_Nro
			FROM 
				(
					SELECT
						Id_Tipo_Cbte, MAX(Nro_Cbte) AS Prox_Nro
						FROM #Cbtes_Insert CS
						GROUP BY Id_Tipo_Cbte
				)RN
			WHERE RN.Prox_Nro IS NOT NULL
			)
	UPDATE Cbtes_Tipos SET Prox_Nro = (T.Prox_Nro) + 1 from temp AS T LEFT JOIN Cbtes_Tipos AS CT ON T.Id_Tipo_Cbte = CT.Id_Tipo_Cbte

	IF @pModoDebug <> 0	
	BEGIN
		PRINT 'Actualizo Prox Nro en Cbtes_Tipos. Hora Ejecucion: ' + CONVERT(VARCHAR(25),GETDATE())
	END

	-- Genero tabla Items_Insert con datos para Cbtes_Items
	SELECT C.*, PR.Id_Trans_Facturar
	INTO #Items_Insert_Generar_IdItem
	FROM #Total_Contratos_Items C
		LEFT JOIN Prod_Listas_Precios P ON C.Id_Lista_Precio = P.Id_Lista_Precio
		LEFT JOIN #Total_Contratos_Cbtes PR ON C.Id_Contrato = PR.Id_Contrato
		ORDER BY C.Id_Contrato

	SET @AlterTable = 'ALTER TABLE #Items_Insert_Generar_IdItem 
						ADD Id_Item INT IDENTITY(1, 1);'

	EXEC (@AlterTable)

	SELECT I.*, RANK() OVER (PARTITION BY I.ID_TRANS_FACTURAR ORDER BY I.Id_Item) AS Orden INTO #Items_Insert FROM #Items_Insert_Generar_IdItem I

	IF @pModoDebug <> 0	
	BEGIN
		PRINT 'Agregue #Items_Insert. Hora Ejecucion: ' + CONVERT(VARCHAR(25),GETDATE())
	END

	-- Separo Items que desglosan por mes en tabla Items_Insert_Desglosa
	SELECT * INTO #Items_Insert_Desglosa FROM #Items_Insert WHERE Flag_Mes_Desglo = 1 AND Cantidad > 1

	IF @pModoDebug <> 0	
	BEGIN
		PRINT 'Agregue #Items_Insert_Desglosa. Hora Ejecucion: ' + CONVERT(VARCHAR(25),GETDATE())
	END

	DELETE #Items_Insert FROM #Items_Insert AS I WHERE EXISTS (SELECT * FROM #Items_Insert_Desglosa D WHERE I.Id_Contrato = D.Id_Contrato and I.Id_Producto  = D.Id_Producto ) AND Id_Trans_Remito = 0

	IF @pModoDebug <> 0	
	BEGIN
		PRINT 'Borre #Items_Insert_Desglosa de  #Items_Insert. Hora Ejecucion: ' + CONVERT(VARCHAR(25),GETDATE())
	END

	------------------------------------------------------------- FIN DE GENERACION DE TABLAS DE DATOS -------------------------------------------------------------

	------------------------------------------------------------------- INSERTO DATOS EN TABLAS -------------------------------------------------------------------

	IF(@Flag_Agru_Cli_Ref = 1)
	BEGIN
		INSERT INTO Cbtes
						(Id_Trans,				Id_Sucursal,		Id_Tipo_Cbte, 
						Comprobante_Nro,		Id_Cliente,			Id_Estado_Cbte, 
						Fecha,					Porc_Iva,			Porc_Iva2, 
						Imp_Exento,				Imp_Total,			Id_Usuario, 
						Porc_Iva3,				Saldo,				Periodo_Iva, 
						Periodo,				Fecha_Venc,			Id_Cond_Pago,
						Cant_Cuotas,			Cantidad,			Id_Lista, 
						Id_Moneda,				Cotizacion,			Destinatario, 
						Cuit,					Id_Iva,				Lote, 
						Id_Contrato,			Id_Cobrador,		Email, 
						Flag_Lote)
				SELECT 	Id_Trans_Facturar,		Id_Sucursal,		Id_Tipo_Cbte,
						Nro_Cbte,				Id_Cliente_Ref,		Id_Estado_Cbte,
       					@pFecha_QA, 	     	@Iva_1,				@Iva_2, 
       					Precio_Cont, 		    Precio_Cont,		-1,
						@Iva_3,					Precio_Cont,		@pFecha_QA,
						@pFecha_QA,				@pFecha_Hasta,		Cond_Pago_Cbte,
						1,						1,					Id_Lista_Precio,
						'PES',					1,					Razon_Social,
						Cuit,					Id_IVA,				@pLote,
						Id_Contrato,			Id_Cobrador,		Email,
						1
						FROM #Cbtes_Insert C
	END
	ELSE
	BEGIN
		INSERT INTO Cbtes
						(Id_Trans,				Id_Sucursal,		Id_Tipo_Cbte, 
						Comprobante_Nro,		Id_Cliente,			Id_Estado_Cbte, 
						Fecha,					Porc_Iva,			Porc_Iva2, 
						Imp_Exento,				Imp_Total,			Id_Usuario, 
						Porc_Iva3,				Saldo,				Periodo_Iva, 
						Periodo,				Fecha_Venc,			Id_Cond_Pago,
						Cant_Cuotas,			Cantidad,			Id_Lista, 
						Id_Moneda,				Cotizacion,			Destinatario, 
						Cuit,					Id_Iva,				Lote, 
						Id_Contrato,			Id_Cobrador,		Email, 
						Flag_Lote)
				SELECT 	Id_Trans_Facturar,		Id_Sucursal,		Id_Tipo_Cbte,
						Nro_Cbte,				Id_Cliente,			Id_Estado_Cbte,
       					@pFecha_QA, 	     	@Iva_1,				@Iva_2, 
       					Precio_Cont, 		    Precio_Cont,		-1,
						@Iva_3,					Precio_Cont,		@pFecha_QA,
						@pFecha_QA,				@pFecha_Hasta,		Cond_Pago_Cbte,
						1,						1,					Id_Lista_Precio,
						'PES',					1,					Razon_Social,
						Cuit,					Id_IVA,				@pLote,
						Id_Contrato,			Id_Cobrador,		Email,
						1
						FROM #Cbtes_Insert C
	END

	IF @pModoDebug <> 0	
	BEGIN
		PRINT 'Agregue Cbtes'
	END

	
	IF(@Flag_Agru_Cli_Ref = 1)
	BEGIN
		INSERT INTO Clientes_CtaCte 
									(Id_Trans,			Nro_Cuota,			Id_Empresa,
									Id_Cliente,			Fecha,				Fecha_Vence,
									Descripcion,		Importe,			Id_Estado_Cbte,
									Observacion,		Id_Trans_Origen,	Nro_Cuota_Origen,
									Id_Moneda,			Saldo,				Nro_FacCre)
							SELECT Id_Trans_Facturar,	1,					0,
									Id_Cliente,			@pFecha_QA,			@pFecha_QA,	     			
									Cbte_Descrip,		Precio_Cont,		Id_Estado_Cbte,
									'',					0,					1,
									'PES',				Precio_Cont,		0
									FROM #Cbtes_Insert C
	END
	ELSE
	BEGIN
		INSERT INTO Clientes_CtaCte 
									(Id_Trans,			Nro_Cuota,			Id_Empresa,
									Id_Cliente,			Fecha,				Fecha_Vence,
									Descripcion,		Importe,			Id_Estado_Cbte,
									Observacion,		Id_Trans_Origen,	Nro_Cuota_Origen,
									Id_Moneda,			Saldo,				Nro_FacCre)
							SELECT Id_Trans_Facturar,	1,					0,
									Id_Cliente,			@pFecha_QA,			@pFecha_QA,	     			
									Cbte_Descrip,		Precio_Cont,		Id_Estado_Cbte,
									'',					0,					1,
									'PES',				Precio_Cont,		0
									FROM #Cbtes_Insert C
	END

	IF @pModoDebug <> 0	
	BEGIN
		PRINT 'Agregue Clientes_Ctacte. Hora Ejecucion: ' + CONVERT(VARCHAR(25),GETDATE())
	END
	/*Comentado por Maca 21/05/24 ------------ Ya agrega todos los items, ya tiene el item bonificacdo cuando corresponde*/
	--IF(@Id_Producto_Bonif = '')
	--BEGIN
		INSERT INTO Cbtes_Items 
								(Id_Trans,					Item,							Id_Producto, 
								Id_Estado_Cbte,				Cantidad,						Bultos, 
								Fecha_Venc,					Observacion,					Millas, 
								Cantidad_Saldo,				Precio_Grav,					Imp_Gravado,
								Flag_QA,					Fecha_QA,						Descripcion_producto, 
								Imp_Final,					Precio,							Id_Cliente, 
								Lote,						Id_Usuario,						Porc_Iva, 
								Imp_Iva,					Id_Cond_Pago)
						SELECT  Id_Trans_Facturar,			Orden,							I.Id_Producto,
								1,							1,								0,
       							@pFecha_Venc,				'',								0, 		     			
								1,							(Precio_Item * I.Cantidad),		(Precio_Item * I.Cantidad),
								'A',						@pFecha_QA,						PR.Descripcion_Resumida,
								(Precio_Item * I.Cantidad),	(Precio_Item * I.Cantidad),		Id_Cliente, 
								@pLote,						-1,								0, 
								0,							I.Id_Cond_Pago_Prod
								FROM #Items_Insert I
								JOIN Productos PR ON I.Id_Producto COLLATE Modern_Spanish_CI_AS = PR.Id_Producto COLLATE Modern_Spanish_CI_AS
								ORDER BY I.Id_Contrato, I.Id_Producto
	--END
	IF @pModoDebug <> 0	
	BEGIN
		PRINT 'Agregue Cbtes_Items. Hora Ejecucion: ' + CONVERT(VARCHAR(25),GETDATE())
	END

	DECLARE @Insertado INT
	DECLARE @Cantidad_Item INT
	DECLARE @Desglozar_Fecha_QA DATE
	DECLARE @Desglozar_Fecha_Venc DATE
	DECLARE @Id_Trans_Insert INT
	DECLARE @Item INT
	DECLARE @Contador INT

	DECLARE curInsert CURSOR FOR
	select Orden, Id_Trans_Facturar, Cantidad from #Items_Insert_Desglosa ORDER BY Id_Contrato, Id_Producto

	OPEN curInsert
	FETCH NEXT FROM curInsert INTO @Item, @Id_Trans_Insert, @Cantidad_Item
	WHILE @@FETCH_STATUS = 0
	BEGIN

		SET @Contador = 1

		WHILE @Contador <= @Cantidad_Item
		BEGIN
			SET @Insertado = (ISNULL((SELECT MAX(ISNULL(Item, 0)) FROM CBTES_ITEMS WHERE Id_Trans = @Id_Trans_Insert), 0)) + 1
			SET @Desglozar_Fecha_QA		= dbo.CF_FOMONTH(DATEADD(MONTH, @Contador, @pFecha_QA))
			SET @Desglozar_Fecha_Venc	= dbo.CF_EOMONTH(@Desglozar_Fecha_QA)
			INSERT INTO Cbtes_Items 
								(Id_Trans,					Item,							Id_Producto, 
								Id_Estado_Cbte,				Cantidad,						Bultos, 
								Fecha_Venc,					Observacion,					Millas, 
								Cantidad_Saldo,				Precio_Grav,					Imp_Gravado,
								Flag_QA,					Fecha_QA,						Descripcion_producto, 
								Imp_Final,					Precio,							Id_Cliente, 
								Lote,						Id_Usuario,						Porc_Iva, 
								Imp_Iva,					Id_Cond_Pago)
					SELECT		P.Id_Trans_Facturar,		@Insertado,						P.Id_Producto,
								1,							1,								0,
       							@pFecha_Venc,				'',								0, 		     			
								1,							P.Precio_Item,					P.Precio_Item,
								'A',						@pFecha_QA,						PR.Descripcion_Resumida,
								P.Precio_Item,				P.Precio_Item,					P.Id_Cliente, 
								@pLote,						-1,								0, 
								0,							P.Id_Cond_Pago_Prod
							FROM #Items_Insert_Desglosa P
									JOIN Productos PR ON P.Id_Producto COLLATE Modern_Spanish_CI_AS = PR.Id_Producto COLLATE Modern_Spanish_CI_AS
									WHERE P.Orden = @Item AND P.Id_Trans_Facturar = @Id_Trans_Insert
									ORDER BY P.Id_Contrato, P.Id_Producto
									

			SET @Contador += 1
		END	
		FETCH NEXT FROM curInsert INTO @Item, @Id_Trans_Insert, @Cantidad_Item
	END
	CLOSE curInsert
	DEALLOCATE curInsert

	------------------------------------------------------------------- FIN INSERTO DATOS EN TABLAS -------------------------------------------------------------------

	------------------------------------------------------------------- FINALIZACION DE FACTURACION DE LOTE -------------------------------------------------------------------

	-- Actualizo registro en tabla Cbtes_Lotes
	UPDATE Cbtes_Lotes SET Cantidad = (SELECT COUNT(*) FROM Cbtes WHERE Lote = @pLote), Importe = ISNULL((SELECT SUM(Imp_Total) FROM Cbtes WHERE Lote = @pLote),0), Fecha_Finalizacion = GETDATE(), Flag_enProceso = 0 WHERE Lote = @pLote
	
	IF @Procesa_Remitos = 1
	BEGIN	
		UPDATE Cbtes SET Saldo = 0, Id_Estado_Cbte = 2 WHERE Id_Trans IN (SELECT Id_Trans FROM #Remitos_Fact)
	END

	-- Genero los asientos de los comprobantes insertados
	IF dbo.CF_xParam('Lote:Asi_Generar') = 1
	BEGIN
		DECLARE curCbtes_Ctas_Contables CURSOR FOR
		select  Id_Trans_Facturar from #Cbtes_Insert ORDER BY Id_Contrato

		OPEN curCbtes_Ctas_Contables
		FETCH NEXT FROM curCbtes_Ctas_Contables INTO  @Id_Trans_Insert
		WHILE @@FETCH_STATUS = 0
		BEGIN

			SET @JSON_Parametros_Stored_Invocado =	'{' +
														dbo.CF_Json_ParsearVariable('FlagUsarTrans', 0, 'INT') + ',' +
														dbo.CF_Json_ParsearVariable('Id_Trans', @Id_Trans_Insert, 'INT') + ',' +
														dbo.CF_Json_ParsearVariable('ModoDebug', @pModoDebug, 'INT') + ',' +
														dbo.CF_Json_ParsearVariable('FlagRegenerar', 1, 'TINYINT') + 
														'}'

			INSERT INTO @Result_Tabla_Stored_Invocado					
				EXEC @Result_Stored_Invocado = dbo.CPJ_Cbtes_Ctas_Contables_Generar @JSON_Parametros_Stored_Invocado

			IF ISNULL(@Result_Stored_Invocado,0) <> 0 
			BEGIN
				SELECT * FROM @Result_Tabla_Stored_Invocado
				RETURN 9999
			END		
			IF @pModoDebug <> 0	
			BEGIN
				PRINT 'Finalizar Trans: '+ CONVERT(VARCHAR(20),@Id_Trans_Insert) + '. Hora Ejecucion: ' + CONVERT(VARCHAR(25),GETDATE())
			END

			FETCH NEXT FROM curCbtes_Ctas_Contables INTO  @Id_Trans_Insert
		END
		CLOSE curCbtes_Ctas_Contables
		DEALLOCATE curCbtes_Ctas_Contables
	END

	------------------------------------------------------------------- FIN DE FACTURACION DE LOTE -------------------------------------------------------------------

	IF OBJECT_ID (N'#Total_Contratos', N'U') IS NOT NULL 
	BEGIN
		DROP TABLE #Total_Contratos
	END
	IF OBJECT_ID (N'#Z_Contratos_Facturados', N'U') IS NOT NULL 
	BEGIN
		DROP TABLE #Total_Contratos
	END
	IF OBJECT_ID (N'#Z_Productos_Facturados', N'U') IS NOT NULL 
	BEGIN
		DROP TABLE #Z_Productos_Facturados
	END
	IF OBJECT_ID (N'#Total_Contratos_Items', N'U') IS NOT NULL 
	BEGIN
		DROP TABLE #Total_Contratos_Items
	END
	IF OBJECT_ID (N'#Cont_Tiempo', N'U') IS NOT NULL 
	BEGIN
		DROP TABLE #Cont_Tiempo
	END
	IF OBJECT_ID (N'#Total_Contratos_Cbtes', N'U') IS NOT NULL 
	BEGIN
		DROP TABLE #Total_Contratos_Cbtes
	END
	IF OBJECT_ID (N'#Ult_Fech_Fac', N'U') IS NOT NULL 
	BEGIN
		DROP TABLE #Ult_Fech_Fac
	END
	IF OBJECT_ID (N'#Cbtes_Insert', N'U') IS NOT NULL 
	BEGIN
		DROP TABLE #Cbtes_Insert
	END
	IF OBJECT_ID (N'#Items_Insert', N'U') IS NOT NULL 
	BEGIN
		DROP TABLE #Items_Insert
	END
	IF OBJECT_ID (N'#Items_Insert_Desglosa', N'U') IS NOT NULL 
	BEGIN
		DROP TABLE #Items_Insert_Desglosa
	END
	IF OBJECT_ID (N'#Remitos_Fact', N'U') IS NOT NULL 
	BEGIN
		DROP TABLE #Remitos_Fact
	END			

	SET @Segundos = (SELECT DATEDIFF(s,Fecha_Inicio,Fecha_Finalizacion) FROM CBTES_LOTES WHERE LOTE = @pLote) 
	SET @Mensaje = 'Minutos Transcurridos: ' + CONVERT(VARCHAR(10),(@Segundos / 60 )  ) + ' ( ' + CONVERT(VARCHAR(10),(@Segundos)) +' segundos).'
 
	SELECT	 0				AS ErrorNumber 
			,0				AS ErrorSeverity  
			,0				AS ErrorState 
			,0				AS ErrorProcedure  
			,0				AS ErrorLine		
			,@Mensaje		AS ErrorMessage

END TRY  
BEGIN CATCH  
	    
    EXECUTE usp_GetErrorInfo
	
	UPDATE Cbtes_Lotes SET Cantidad = (SELECT COUNT(*) FROM Cbtes WHERE Lote = @pLote), Importe = (SELECT SUM(Imp_Total) FROM Cbtes WHERE Lote = @pLote), Fecha_Finalizacion = GETDATE(), Flag_enProceso = 0 WHERE Lote = @pLote

	IF (SELECT CURSOR_STATUS('global','curInsert') ) = -1
		DEALLOCATE curInsert		 

	IF (SELECT CURSOR_STATUS('global','curCbtes_Ctas_Contables') ) = 1
	BEGIN
		CLOSE curCbtes_Ctas_Contables
		DEALLOCATE curCbtes_Ctas_Contables		 
	END


	RETURN 9999
END CATCH

RETURN 0

/*

DECLARE @Param VARCHAR(5000)
SET @Param = '{' +
			'"Lote":"PRUEBA_OCT_A",' +
			'"Fecha":"20231001",' +
			'"Descripcion":"PRUEBA_OCT_A",' +
			'"Id_Lote_Tipo":"1",' + 
			'"Fecha_Desde":"20231001",' +
			'"Fecha_Hasta":"20231031"' +
			'"Fecha_QA":"20231001",' +
			'"Fecha_Venc":"20231031"' +
			'"Fecha_Rem_Desde":"20230901",' +
			'"Fecha_Rem_Hasta":"20230930",' +
			'"Id_Tipo_Cont":"1",' +
			'"Id_Usuario":"-1",' +
			'"FiltrarTarjeta":"0",' +
			'"FiltrarCliente":"0",' +
			'"FiltrarCondPago":"0",' +
			'"FiltrarTipoCbte":"0",' +
			'"FiltrarCantCont":"0",' +
			'"Refacturar":"0",' +
			'"Incl_Cbtes_Cero":"0",' +
			'"FlagUsarTrans":"0",' +
			'"ModoDebug":"0"' +
			'}'

EXEC CPJ_Cbtes_Lotes_Facturar_V2 @Param

*/
